# Cloudflare Turnstile für vBulletin 3.8 (Human Verification)

**Version:** 1.0.0  
**Kompatibilität:** vBulletin 3.8.x · PHP 5.6  
**Autor/Release:** kerimcandan.com

Dieser Treiber ersetzt Google reCAPTCHA durch **Cloudflare Turnstile** im integrierten vBulletin-Human-Verification-System (HV). Damit erscheinen die Challenges automatisch in allen Bereichen, in denen HV von vBulletin verwendet wird (z. B. *Neues Thema*, *Antworten*, *Kontakt*, *Private Nachrichten*, *Registrierung* je nach Board‑Einstellungen).

---

## Inhalt des ZIP
- `includes/class_humanverify_turnstile.php` – PHP‑Treiber (Serverdatei)
- `README_DE.md` – Diese Anleitung

> **Wichtig:** Die Produkt-XML (**`product-turnstile_vb3.xml`**) wird **separat** im AdminCP importiert und liegt daher *nicht* in diesem ZIP.

---

## Voraussetzungen
- vBulletin **3.8.x**
- PHP **5.6**
- Cloudflare Turnstile **Site Key** und **Secret Key** (im Cloudflare‑Dashboard erstellen)
- Domain‑Freigabe in Turnstile (unter *Domain Restrictions* ggf. `example.com`/`www.example.com` erlauben)

---

## Installation

1. **Datei hochladen**  
   `class_humanverify_turnstile.php` nach **`/includes/`** auf dem Server kopieren.

2. **Produkt importieren** *(separat, nicht im ZIP)*  
   AdminCP → **Plugins & Products** → **Manage Products** → **Add/Import Product** → Datei **`product-turnstile_vb3.xml`** wählen → *Import*.

3. **Einstellungen setzen**  
   AdminCP → **Settings** → **Human Verification Manager**  
   - **Verification Type (hv_type):** **Turnstile**  
   - **Turnstile Site Key:** `DEIN_SITEKEY`  
   - **Turnstile Secret Key:** `DEIN_SECRET`  
   - Optional: **Theme** (light/dark), **Size** (normal/compact)

4. **Funktionstest (AdminCP)**  
   Rufe im AdminCP auf: `verify.php?do=turnstile_vb3_test_display`  
   → Widget sollte angezeigt werden; mit **Verify** prüfen.

5. **Styles/Cache aktualisieren**  
   AdminCP → **Rebuild/Refresh Styles** und Browser‑Cache leeren (Strg+F5).

---

## Deinstallation / Rückbau
- AdminCP → **Manage Products** → Produkt **Cloudflare Turnstile** *uninstall*.  
- Falls du zuvor manuelle Einbauten in Templates/`newthread.php` gemacht hast: diese wieder entfernen (für die reine Plugin‑Variante nicht nötig).

---

## Hinweise & Troubleshooting
- **Widget erscheint nicht:**  
  - Prüfe, ob `https://challenges.cloudflare.com/turnstile/v0/api.js` im Browser geladen wird (Ad‑Blocker/Privacy‑Addons ggf. deaktivieren).  
  - Mixed‑Content vermeiden: externe Skripte **nur via HTTPS** einbinden (z. B. altes jQuery).
  - In Turnstile die **Domain Restrictions** korrekt setzen.
- **Prüfung schlägt fehl:**  
  - Secret Key korrekt? Server kann die Cloudflare‑API erreichen (cURL/Streams)?  
  - Teste im AdminCP unter `verify.php?do=turnstile_vb3_test_display`.
- **Doppelte Captchas:**  
  - Entferne frühere manuelle Captcha‑Snippets (Templates/Custom‑Hooks). Für die Plugin‑Lösung ist das nicht nötig.

---

## Changelog
**1.0.0** – Erstveröffentlichung (Driver + Admin‑Testseite + Settings/Template/Phasen).

---

© 2025 kerimcandan.com – Bereitgestellt „as is“, Nutzung auf eigene Verantwortung.
