<?php
if (!isset($GLOBALS['vbulletin']->db))
{
    exit;
}

require_once(DIR . '/includes/class_vurl.php');

class vB_HumanVerify_Turnstile extends vB_HumanVerify_Abstract
{
    public static $verify_url = 'https://challenges.cloudflare.com/turnstile/v0/siteverify';

    function vB_HumanVerify_Turnstile(&$registry)
    {
        parent::__construct($registry);
    }

    /**
     * Output widget HTML
     *
     * @param string $var_prefix
     * @return string
     */
    function output_token($var_prefix = 'humanverify')
    {
        // Prepare token in DB (keeps vB flow happy)
        $humanverify = $this->generate_token();
        $humanverify['publickey'] = trim($this->registry->options['hv_turnstile_sitekey']);
        $humanverify['theme']     = ($this->registry->options['hv_turnstile_theme'] ? $this->registry->options['hv_turnstile_theme'] : 'light');
        $humanverify['size']      = ($this->registry->options['hv_turnstile_size']  ? $this->registry->options['hv_turnstile_size']  : 'normal');

        // vB templates expect $var_prefix in scope
        $var_prefix = $var_prefix;

        // Render our template
        eval('$output = "' . fetch_template('humanverify_turnstile') . '";');
        return $output;
    }

    /**
     * Verify token posted from client
     *
     * @param array $input expects ['hash']
     * @return bool
     */
    function verify_token($input)
    {
        // Accept both Turnstile and reCAPTCHA param names (compat)
        $this->registry->input->clean_array_gpc('p', array(
            'cf-turnstile-response' => TYPE_STR,
            'g-recaptcha-response'  => TYPE_STR,
        ));

        $token = '';
        if (!empty($this->registry->GPC['cf-turnstile-response']))
        {
            $token = trim($this->registry->GPC['cf-turnstile-response']);
        }
        else if (!empty($this->registry->GPC['g-recaptcha-response']))
        {
            // just in case theme still has google field; verify against Turnstile anyway
            $token = trim($this->registry->GPC['g-recaptcha-response']);
        }

        if ($token === '')
        {
            $this->error = 'humanverify_turnstile_noanswer';
            return false;
        }

        // Secret
        $secret = trim($this->registry->options['hv_turnstile_secret']);
        if ($secret === '')
        {
            $this->error = 'humanverify_turnstile_secret';
            return false;
        }

        // Always delete hash, like core drivers do
        $this->delete_token($input['hash']);

        // Build POST fields
        $fields = array(
            'secret'   => $secret,
            'response' => $token,
            // 'remoteip' => $_SERVER['REMOTE_ADDR'], // optional
        );

        // Try vURL first (preferred by vB)
        $result = false;
        if (class_exists('vB_vURL'))
        {
            $vurl = new vB_vURL($this->registry);
            $vurl->set_option(VURL_URL, self::$verify_url);
            $vurl->set_option(VURL_POST, 1);
            $vurl->set_option(VURL_POSTFIELDS, http_build_query($fields));
            $vurl->set_option(VURL_TIMEOUT, 7);
            $vurl->set_option(VURL_RETURNTRANSFER, 1);
            $vurl->set_option(VURL_CLOSECONNECTION, 1);

            $result = $vurl->exec();
        }

        // Fallback to cURL
        if ($result === false || $result === '' || $result === null)
        {
            if (function_exists('curl_init'))
            {
                $ch = curl_init(self::$verify_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
                curl_setopt($ch, CURLOPT_TIMEOUT, 7);
                $result = curl_exec($ch);
                curl_close($ch);
            }
        }

        // Fallback to streams
        if ($result === false || $result === '' || $result === null)
        {
            $ctx = stream_context_create(array(
                'http' => array(
                    'method'  => 'POST',
                    'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                    'content' => http_build_query($fields),
                    'timeout' => 7
                )
            ));
            $result = @file_get_contents(self::$verify_url, false, $ctx);
        }

        if (!$result)
        {
            $this->error = 'humanverify_turnstile_unreachable';
            return false;
        }

        $json = json_decode($result, true);
        if (is_array($json) && !empty($json['success']))
        {
            return true;
        }

        $this->error = 'humanverify_turnstile_wronganswer';
        return false;
    }

    /**
     * Not used for Turnstile; keep abstract contract.
     */
    function fetch_answer()
    {
        return '';
    }

    /* ===== AdminCP self-test helpers (optional) ===== */

    public static function test_check_config()
    {
        global $vbulletin;
        $out = array();

        $site = trim($vbulletin->options['hv_turnstile_sitekey']);
        $sec  = trim($vbulletin->options['hv_turnstile_secret']);

        $out[] = array(($site ? 0 : 1), ($site ? "Site Key present" : "Missing Site Key (hv_turnstile_sitekey)"));
        $out[] = array(($sec  ? 0 : 1), ($sec  ? "Secret Key present"   : "Missing Secret Key (hv_turnstile_secret)"));

        $out[] = array((function_exists('curl_init') ? 0 : 1), (function_exists('curl_init') ? "cURL available" : "cURL not available (fallback to streams)"));

        return $out;
    }

    public static function test_display_widget()
    {
        global $vbulletin;
        $humanverify = array('hash' => md5(uniqid(vbrand(), true)));
        $humanverify['publickey'] = trim($vbulletin->options['hv_turnstile_sitekey']);
        $humanverify['theme']     = ($vbulletin->options['hv_turnstile_theme'] ? $vbulletin->options['hv_turnstile_theme'] : 'light');
        $humanverify['size']      = ($vbulletin->options['hv_turnstile_size']  ? $vbulletin->options['hv_turnstile_size']  : 'normal');

        $var_prefix = 'humanverify';
        eval('$output = "' . fetch_template('humanverify_turnstile') . '";');
        return $output;
    }

    public static function test_verify()
    {
        global $vbulletin;

        $vbulletin->input->clean_array_gpc('p', array(
            'cf-turnstile-response' => TYPE_STR,
        ));
        $token = trim($vbulletin->GPC['cf-turnstile-response']);

        $tmp = new self($vbulletin);
        if ($token === '')
        {
            return array(array(1, "No token posted (cf-turnstile-response)."));
        }

        $ok = $tmp->verify_token(array('hash' => 'dummy'));
        return $ok ? array(array(0, "Verification OK")) : array(array(1, "Verification failed"));
    }
}
?>